#ifndef SAFEMALLOC_GUARD
#define SAFEMALLOC_GUARD

inline
void *SAFE_MALLOC(size_t b){
	void* y= (void*)malloc(b); 
	if(!y){ 
		printf("Could not allocate %.3f MB\n", (double)b/1024.0/1024.0);exit (-1); 
	}
	#if SHOW_DEBUG_OUTPUT
	else{
		printf("SAFE_MALLOC -- Alloccated %.3f MB.\n", (double)b/1024.0/1024.0);
	}
	#endif
	return y;
}

inline
void *SAFE_CALLOC(size_t b){
	void* y= (void*)calloc(b,1); 
	if(!y){ 
		printf("Could not allocate %.3f MB\n", (double)b/1024.0/1024.0);exit (-1); 
	}
	#if SHOW_DEBUG_OUTPUT
	else{
		printf("SAFE_CALLOC -- Alloccated %.3f MB.\n", (double)b/1024.0/1024.0);
	}
	#endif
	return y;
}
#endif
